//
//  LicensePlateView.swift
//  KennDeinZeichen
//
//  Created by Michael Zügel on 02.11.25.
//
import SwiftUI

struct LicensePlateView: View {
    var districtCode: String
    
    var body: some View {
        HStack(spacing: 0) {
            // Blue "D" section
            Text("D")
                .font(.system(size: 12, weight: .heavy))
                .foregroundColor(.white)
                .frame(maxHeight: .infinity)
                .frame(width: 20)
                .background(Color.blue)

            // District code
            Text(districtCode)
                .font(.system(.body, design: .monospaced))
                .padding(.horizontal, 8)
                .padding(.vertical, 4)
        }
        .overlay(
            RoundedRectangle(cornerRadius: 4)
                .stroke(Color.black, lineWidth: 2)
        )
        .fixedSize()
    }
}

#Preview {
    LicensePlateView(districtCode: "HH MZ 4224E")
}
