//
//  RegisrationDistrict.swift
//  KennDeinZeichen
//
//  Created by Michael Zügel on 01.11.25.
//

import Foundation
import UIKit

// Represents the data for a German vehicle registration district
struct RegistrationDistrict: Codable, Hashable, Identifiable {
    var id: String { districtCode } // Make it identifiable for use in SwiftUI lists

    let districtCode: String
    let origin: String
    let country: String?
    let isSpecialPlate: Bool
    let isObsoletePlate: Bool
    
    static func loadRegistrationDistricts() -> [RegistrationDistrict]? {
        // 1. Use the name of your data set from the asset catalog.
        guard let asset = NSDataAsset(name: "registrationDistricts") else {
            print("Error: Could not find the asset 'german_license_plates'.")
            return nil
        }

        // 2. Get the data from the asset.
        let data = asset.data

        // 3. Decode the data into an array of your struct.
        do {
            let decoder = JSONDecoder()
            let plates = try decoder.decode([RegistrationDistrict].self, from: data)
            return plates
        } catch {
            print("Error: Failed to decode JSON. \(error)")
            return nil
        }
    }
}
