//
//  RegistrationDistrictSimple.swift
//  KennDeinZeichenStarter
//
//  Created by Michael Zügel on 01.11.25.
//
import Foundation
import UIKit
import OSLog

struct RegistrationDistrictSimple: Identifiable, Decodable {
    var id: String { districtCode }
    let districtCode: String
    let origin: String
    
    static var sampleDistricts: [RegistrationDistrictSimple] {
        [
            RegistrationDistrictSimple(districtCode: "S", origin: "Stuttgart"),
            RegistrationDistrictSimple(districtCode: "HH", origin: "Hansestadt Hamburg"),
            RegistrationDistrictSimple(districtCode: "BB", origin: "Böblingen"),
            RegistrationDistrictSimple(districtCode: "LEO", origin: "Böblingen"),
            RegistrationDistrictSimple(districtCode: "M", origin: "München"),
            RegistrationDistrictSimple(districtCode: "KS", origin: "Kassel"),
            RegistrationDistrictSimple(districtCode: "LB", origin: "Ludwigsburg")
        ]
    }
    
    static func loadRegistrationDistricts(from name: String = "registrationDistricts") -> [RegistrationDistrictSimple]? {
        // 1. Load data from the asset catalog via NSDataAsset.
        guard let dataAsset = NSDataAsset(name: name) else {
            os_log("Failed to find data asset named '\(name, privacy: .public)'.")
            return nil
        }
        
        // 2. Get the raw Data from the asset.
        let data = dataAsset.data
        
        // 3. Decode the data into an array of RegistrationDistrictSimple.
        do {
            let decoder = JSONDecoder()
            let districts = try decoder.decode([RegistrationDistrictSimple].self, from: data)
            return districts
        } catch {
            os_log("Decoding error for '\(name, privacy: .public)'")
            return nil
        }
    }
}
