//
//  RegistrationDistrictSimple.swift
//  KennDeinZeichenStarter
//
//  Created by Michael Zügel on 01.11.25.
//
import Foundation
import UIKit
import OSLog

struct RegistrationDistrictSimple: Identifiable, Decodable {
    var id: String { districtCode }
    let districtCode: String
    let origin: String
    
    static var sampleDistricts: [RegistrationDistrictSimple] {
        [
            RegistrationDistrictSimple(districtCode: "S", origin: "Stuttgart"),
            RegistrationDistrictSimple(districtCode: "HH", origin: "Hansestadt Hamburg"),
            RegistrationDistrictSimple(districtCode: "BB", origin: "Böblingen"),
            RegistrationDistrictSimple(districtCode: "LEO", origin: "Böblingen"),
            RegistrationDistrictSimple(districtCode: "M", origin: "München"),
            RegistrationDistrictSimple(districtCode: "KS", origin: "Kassel"),
            RegistrationDistrictSimple(districtCode: "LB", origin: "Ludwigsburg")
        ]
    }
    
    static func loadRegistrationDistricts(from name: String = "registrationDistricts") -> [RegistrationDistrictSimple]? {
        // 1. Use the name of your data set from the asset catalog.
        // If you want it on your own: check NSDataAsset and how it's used
    

        // 2. Get the data from the asset.

        // 3. Decode the data into an array of your struct.
        // Check JSONDecoder and how to decode 'data'
        // Note: A 'do' 'try' 'catch' helps here and will be recommended by the IDE given this process can throw an exception.
        
        // 4. Return Data

        return nil
    }
}
